implementation module osfileselect

import	clCrossCall
import	osevent
from	commondef	import FatalError

osfileselectFatalError :: String String -> .x
osfileselectFatalError function error
	= FatalError function "osfileselect" error

OSselectinputfile :: !(OSEvent->.s->.s) !.s !*OSToolbox -> (!Bool,!String,!.s,!*OSToolbox)
OSselectinputfile handleOSEvent state tb
	# selectcci			= {ccMsg=CcRqFILEOPENDIALOG,p1=0,p2=0,p3=0,p4=0,p5=0,p6=0}
	# (rcci,state,tb)	= IssueCleanRequest (callback handleOSEvent) selectcci state tb
	# (ok,name,tb)		= getinputfilename rcci tb
	= (ok,name,state,tb)
where
	getinputfilename :: !CrossCallInfo !*OSToolbox -> (!Bool,!String,!*OSToolbox)
	getinputfilename {ccMsg=CcRETURN2,p1=ok,p2=ptr} tb
		| ok==0
		= (False,"",tb)
		# (pathname,tb)	= WinGetCStringAndFree ptr tb
		= (True,pathname,tb)
	getinputfilename {ccMsg=CcWASQUIT} tb
		= (False,"",tb)
	getinputfilename {ccMsg} _
		= osfileselectFatalError "OSselectinputfile" ("unexpected ccMsg field of return CrossCallInfo ("+++toString ccMsg+++")")

OSselectoutputfile :: !(OSEvent->.s->.s) !.s !String !String !*OSToolbox -> (!Bool,!String,!.s,!*OSToolbox)
OSselectoutputfile handleOSEvent state prompt filename tb
	# (promptptr,  tb)	= WinMakeCString prompt   tb
	# (filenameptr,tb)	= WinMakeCString filename tb
	  savecci			= {ccMsg=CcRqFILESAVEDIALOG,p1=promptptr,p2=filenameptr,p3=0,p4=0,p5=0,p6=0}
	# (rcci,state, tb)	= IssueCleanRequest (callback handleOSEvent) savecci state tb
	# tb				= WinReleaseCString promptptr   tb
	# tb				= WinReleaseCString filenameptr tb
	# (ok,name,tb)		= getoutputfilename rcci tb
	= (ok,name,state,tb)
where
	getoutputfilename :: !CrossCallInfo !*OSToolbox -> (!Bool,!String,!*OSToolbox)
	getoutputfilename {ccMsg=CcRETURN2,p1=ok,p2=ptr} tb
		| ok==0
		= (False,"",tb)
		# (path,tb) = WinGetCStringAndFree ptr tb
		= (True,path,tb)
	getoutputfilename {ccMsg=CcWASQUIT} tb
		= (False,"",tb)
	getoutputfilename {ccMsg} _
		= osfileselectFatalError "OSselectoutputfile" ("unexpected ccMsg field of return CrossCallInfo ("+++toString ccMsg+++")")

//	callback lifts a function::(OSEvent -> .s -> .s) to
//        a crosscallfunction::(CrossCallInfo -> .s -> *OSToolbox -> (CrossCallInfo,.s,*OSToolbox))
callback :: !(OSEvent->.s->.s) !CrossCallInfo !.s !*OSToolbox -> (!CrossCallInfo,!.s,!*OSToolbox)
callback handleOSEvent cci state tb = (Return0Cci,handleOSEvent cci state,tb)
